load("bm/BM_data_9.Rdata")
load("bm/bm_processed.Rdata")
num_reps = 20
alphas <- c(0.7, 0.5, 0.3, 0.2, 0.1, 0)
j=5
for(j in 1:length(alphas)){
  p <- data_cts$n_dim_r
  alpha <- alphas[j]

  est1_SMC <- est2_SMC <-
    est1_ZZ <- est2_ZZ <- est1_ZZ1 <-
    est2_ZZ1 <- matrix(0, nrow = p, ncol = num_reps)

  n_iter <- rep(0, num_reps)

  stick_to_one_all <- rep(0,num_reps)
  comp_eff_all <- matrix(0, num_reps, 2)
  ngrads <- matrix(0, num_reps, 2)
  i=1
  for( i in 1:num_reps ){
    fe <- file.exists(paste0("bm/Cluster Code/ZZ/short_rbm_alpha_",alpha,"_iter_",i,".Rdata"))

    if(fe){
      load(paste0("bm/Cluster Code/ZZ/short_rbm_alpha_",alpha,"_iter_",i,".Rdata"))

      stick_to_one_all[i] = stick_to_one
      est1_ZZ[,i] <- est1; est2_ZZ[,i] <- est2

      comp_eff_all[i,1] <- comp_eff
      ngrads[i,1] <- ngrad

      load(paste0("bm/Cluster Code/ZZ/short_rbm_alpha_",1,"_iter_",i,".Rdata"))
      est1_ZZ1[,i] <- est1; est2_ZZ1[,i] <- est2

      comp_eff_all[i,2] <- comp_eff
      ngrads[i,2] <- ngrad
    } else{
      ind_rem <- c(ind_rem, i)
    }
  }
  prob_1 <- c(1,mean(stick_to_one_all))
  comp <- colMeans(comp_eff_all)[c(2,1)]

  ngrad1 <- matrix(ngrads[,1], nrow = p, ncol = num_reps, byrow = T)
  ngrad2 <- matrix(ngrads[,2], nrow = p, ncol = num_reps, byrow = T)
  rmse_1 <- rbind(sqrt(rowMeans((est1_ZZ1 - matrix(rep(exact_mean,num_reps), ncol = num_reps))^2 * ngrad1)),
                  sqrt(rowMeans((est1_ZZ - matrix(rep(exact_mean,num_reps), ncol = num_reps))^2 * ngrad2)))
  rmse_2 <- rbind(sqrt(rowMeans((est2_ZZ1 - matrix(rep(diag(exact_cov),num_reps), ncol = num_reps) )^2* ngrad1 )),
                  sqrt(rowMeans((est2_ZZ - matrix(rep(diag(exact_cov),num_reps), ncol = num_reps))^2 * ngrad2)))

  rmse_1 <- rbind(rmse_1[1,]/rmse_1[1,],
                  rmse_1[1,]/rmse_1[2,])
  rmse_2 <- rbind(rmse_2[1,]/rmse_2[1,],
                  rmse_2[1,]/rmse_2[2,])

  method <- c("Zig-Zag","ctZig-Zag")
  if(j ==1){
    row_add <- data.frame(method = method, alpha = c(1,alpha),
                          prob_1 = prob_1, Ex = rmse_1,
                          Ex2 = rmse_2, computation = comp)
  } else {
    row_add <- rbind(row_add,
                     data.frame(method = method, alpha = c(1,alpha),
                                prob_1 = prob_1, Ex = rmse_1,
                                Ex2 = rmse_2, computation = comp)[-1,])
  }
}
row_add[,1:29]
knitr::kable(data.frame(row_add[,1:3],Ex_error = rowMeans(row_add[,3:29]),
                        Ex2_error = rowMeans(row_add[,30:55]), eff = row_add[,56]))

stargazer::stargazer(data.frame(row_add[,1:3],Ex_error = rowMeans(row_add[,3:29]),
                                Ex2_error = rowMeans(row_add[,30:55]), eff = row_add[,56]), summary = F)


rg <- expand.grid(NT = c(3,5,7),S = c(0.1,1,2), IT=c(0.1,0.3,0.5,0.7))
j=1
for(j in j:nrow(rg)){
  p <- data_cts$n_dim_r
  alpha <- alphas[j]

  est1_PT <- est2_PT <- est1_ZZ1 <-
    est2_ZZ1 <- matrix(0, nrow = p, ncol = num_reps)

  n_iter <- rep(0, num_reps)

  stick_to_one_all <- rep(0,num_reps)
  comp_eff_all <- matrix(0, num_reps, 2)
  ngrads <- matrix(0, num_reps, 2)
  i=1
  ADD=T
  NT <- rg[j,1]; S = rg[j,2]; IT = rg[j,3]
  for( i in 1:num_reps ){
    fe <- file.exists(paste0("bm/Cluster Code/PT/res_S_",S,"_NT_",NT,"_NR_TRUE_rep_",i,"_IT_",IT,".Rdata"))

    if(fe){
      load(paste0("bm/Cluster Code/PT/res_S_",S,"_NT_",NT,"_NR_TRUE_rep_",i,"_IT_",IT,".Rdata"))
      burn <- 1

      est1_PT[,i] <- colMeans(res$out[-c(1:burn),])
      est2_PT[,i] <- colMeans(res$out[-c(1:burn),]^2)

      comp_eff_all[i,1] <- mean(res$prop_swap[,3])
      ngrads[i,1] <- res$n_grad_eval - res$n_eval[burn]

      load(paste0("bm/Cluster Code/ZZ/short_rbm_alpha_",1,"_iter_",i,".Rdata"))
      est1_ZZ1[,i] <- est1; est2_ZZ1[,i] <- est2

      comp_eff_all[i,2] <- comp_eff
      ngrads[i,2] <- ngrad

    } else{
      ADD = FALSE
      print(paste0("NR",rg[j,]))
    }
  }
  if(ADD){
    prob_1 <- c(1,mean(stick_to_one_all))
    comp <- colMeans(comp_eff_all)[c(2,1)]

    ngrad1 <- matrix(ngrads[,1], nrow = p, ncol = num_reps, byrow = T)
    ngrad2 <- matrix(ngrads[,2], nrow = p, ncol = num_reps, byrow = T)
    rmse_1 <- rbind(sqrt(rowMeans((est1_ZZ1 - matrix(rep(exact_mean,num_reps), ncol = num_reps))^2 * ngrad1)),
                    sqrt(rowMeans((est1_PT - matrix(rep(exact_mean,num_reps), ncol = num_reps))^2 * ngrad2)))
    rmse_2 <- rbind(sqrt(rowMeans((est2_ZZ1 - matrix(rep(diag(exact_cov),num_reps), ncol = num_reps) )^2* ngrad1 )),
                    sqrt(rowMeans((est2_PT - matrix(rep(diag(exact_cov),num_reps), ncol = num_reps))^2 * ngrad2)))

    rmse_1 <- rbind(rmse_1[1,]/rmse_1[1,],
                    rmse_1[1,]/rmse_1[2,])
    rmse_2 <- rbind(rmse_2[1,]/rmse_2[1,],
                    rmse_2[1,]/rmse_2[2,])

    method <- c("Zig-Zag",paste0("[NR] PT (",IT,")"))
    row_add <- rbind(row_add,
                     data.frame(method = method, alpha = c(1,NT),
                                prob_1 = S, Ex = rmse_1,
                                Ex2 = rmse_2, computation = comp)[-1,])
  }

  ADD=T
  for( i in 1:num_reps ){
    fe <- file.exists(paste0("bm/Cluster Code/PT/res_S_",S,"_NT_",NT,"_NR_FALSE_rep_",i,"_IT_",IT,".Rdata"))

    if(fe){
      load(paste0("bm/Cluster Code/PT/res_S_",S,"_NT_",NT,"_NR_FALSE_rep_",i,"_IT_",IT,".Rdata"))
      burn <- 1

      est1_PT[,i] <- colMeans(res$out[-c(1:burn),])
      est2_PT[,i] <- colMeans(res$out[-c(1:burn),]^2)

      comp_eff_all[i,1] <- mean(res$prop_swap[,3])
      ngrads[i,1] <- res$n_grad_eval - res$n_eval[burn]

      load(paste0("bm/Cluster Code/ZZ/short_rbm_alpha_",1,"_iter_",i,".Rdata"))
      est1_ZZ1[,i] <- est1; est2_ZZ1[,i] <- est2

      comp_eff_all[i,2] <- comp_eff
      ngrads[i,2] <- ngrad

    } else{
      ADD = FALSE
      print(paste0("R",rg[j,]))
    }
  }
  if(ADD){
    prob_1 <- c(1,mean(stick_to_one_all))
    comp <- colMeans(comp_eff_all)[c(2,1)]

    ngrad1 <- matrix(ngrads[,1], nrow = p, ncol = num_reps, byrow = T)
    ngrad2 <- matrix(ngrads[,2], nrow = p, ncol = num_reps, byrow = T)
    rmse_1 <- rbind(sqrt(rowMeans((est1_ZZ1 - matrix(rep(exact_mean,num_reps), ncol = num_reps))^2 * ngrad1)),
                    sqrt(rowMeans((est1_PT - matrix(rep(exact_mean,num_reps), ncol = num_reps))^2 * ngrad2)))
    rmse_2 <- rbind(sqrt(rowMeans((est2_ZZ1 - matrix(rep(diag(exact_cov),num_reps), ncol = num_reps) )^2* ngrad1 )),
                    sqrt(rowMeans((est2_PT - matrix(rep(diag(exact_cov),num_reps), ncol = num_reps))^2 * ngrad2)))

    rmse_1 <- rbind(rmse_1[1,]/rmse_1[1,],
                    rmse_1[1,]/rmse_1[2,])
    rmse_2 <- rbind(rmse_2[1,]/rmse_2[1,],
                    rmse_2[1,]/rmse_2[2,])

    method <- c("Zig-Zag",paste0("[R] PT (",IT,")"))
    row_add <- rbind(row_add,
                     data.frame(method = method, alpha = c(1,NT),
                                prob_1 = S, Ex = rmse_1,
                                Ex2 = rmse_2, computation = comp)[-1,])
  }

}

R <- data.frame(row_add[,1:3],Ex_error = round(rowMeans(row_add[,3:29]),4),
                Ex2_error = round(rowMeans(row_add[,30:55]),4),
                eff = row_add[,56])
NRi <- grep("NR", R[,1])
Ri <- 1:nrow(R)
Ri <- Ri[-c(1:7,NRi)]
row_add[c(1:7,NRi,Ri),]

indO <- c(1:7,NRi,Ri)

REL_EFF <-data.frame(row_add[indO,1:3],Ex_error = round(rowMeans(row_add[indO,3:29]),4),
                     Ex2_error = round(rowMeans(row_add[indO,30:55]),4),
                     eff = row_add[indO,56])
knitr::kable(data.frame(row_add[indO,1:3],Ex_error = round(rowMeans(row_add[indO,3:29]),4),
                        Ex2_error = round(rowMeans(row_add[indO,30:55]),4)), digits = 2, row.names = F)

REL_EFF
inds <- c(1:7,16,25,34,43, 52,59,70,79)
knitr::kable(REL_EFF[inds,],digits = 2, row.names = F)
stargazer::stargazer(REL_EFF[inds,], summary = F, )

